% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alternatives.R
\name{klDiv}
\alias{klDiv}
\title{Compute the Kullback-Leibler divergence}
\usage{
klDiv(f1, f2, lower = 0, upper = 1)
}
\arguments{
\item{f1}{density function of a real-valued random variable}

\item{f2}{density function of a real-values random variable}

\item{lower}{real value, the lower bound of integration}

\item{upper}{real value, the upper bound of integration}
}
\value{
A real value.
}
\description{
Computes the Kullback-Leibler divergence for two
arbitrary densities f1 and f2.
}
\details{
Given lower and upper bounds, this function integrates
the expression for the Kullback-Leibler divergence KL(f1|f2).
}
\examples{
klDiv(dunif, function(x) dbeta(x, 0.5, 1))
}
\author{
Chris Salahub
}
