% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_helper.R
\name{ml_panel_op}
\alias{ml_panel_op}
\title{Panel-safe binary operation on aligned wide panels}
\usage{
ml_panel_op(A, B, op = `*`, how = c("intersect", "union"), fill = NA_real_)
}
\arguments{
\item{A, B}{Data frames with a \code{Date} column and one column per symbol.}

\item{op}{Binary function to apply elementwise (e.g., \code{*}, \code{/}, \code{+}).}

\item{how}{Character; \code{"intersect"} (default) or \code{"union"} for the set
of symbol columns to operate on.}

\item{fill}{Numeric; value used to fill gaps when \code{how="union"}.}
}
\value{
A data.frame with \code{Date} and the operated symbol columns.
}
\description{
Applies an elementwise binary operator to two date-aligned wide panels
(first column \code{Date}, other columns are symbols), preserving the \code{Date}
column and a consistent symbol set. Supports intersection or union of
column sets; missing entries introduced by \code{how="union"} are filled.
}
\examples{
\dontrun{
out <- ml_panel_op(mom12_panel, vol_panel, op = `*`)
}
}
