% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_analytics.R
\name{plot.performance_analysis}
\alias{plot.performance_analysis}
\title{Plot Performance Analysis Results}
\usage{
\method{plot}{performance_analysis}(x, type = "summary", ...)
}
\arguments{
\item{x}{performance_analysis object}

\item{type}{Plot type: "summary", "returns", "risk", "drawdown"}

\item{...}{Additional plotting parameters}
}
\value{
NULL (creates plot)
}
\description{
S3 method for visualizing performance metrics. Supports multiple plot
types including summary dashboard, return distributions, risk evolution,
and rolling statistics.
}
\examples{
data("sample_prices_weekly")
data("sample_prices_daily")
syms_all <- intersect(names(sample_prices_weekly)[-1], names(sample_prices_daily)[-1])
syms <- syms_all[seq_len(min(3L, length(syms_all)))]
P <- sample_prices_weekly[, c("Date", syms), with = FALSE]
D <- sample_prices_daily[,  c("Date", syms), with = FALSE]
mom <- calc_momentum(P, lookback = 12)
sel <- filter_top_n(mom, n = 3)
W   <- weight_equally(sel)
res <- run_backtest(P, W)
perf <- analyze_performance(res, D, benchmark_symbol = syms[1])
if (interactive()) {
  plot(perf, type = "summary")
}
}
