% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{weight_by_hrp}
\alias{weight_by_hrp}
\title{Hierarchical Risk Parity Weighting}
\usage{
weight_by_hrp(
  selected_df,
  prices_df,
  lookback_periods = 252,
  cluster_method = "ward.D2",
  distance_method = "euclidean",
  min_periods = 60,
  use_correlation = FALSE
)
}
\arguments{
\item{selected_df}{Binary selection matrix (data.frame with Date column)}

\item{prices_df}{Price data for covariance calculation (typically daily)
Returns are calculated internally from prices}

\item{lookback_periods}{Number of periods for covariance estimation (default: 252)}

\item{cluster_method}{Clustering linkage method (default: "ward.D2")}

\item{distance_method}{Distance measure for clustering (default: "euclidean")}

\item{min_periods}{Minimum periods required for calculation (default: 60)}

\item{use_correlation}{If TRUE, cluster on correlation instead of covariance}
}
\value{
Weight matrix with same dates as selected_df
}
\description{
Calculates portfolio weights using Hierarchical Risk Parity (HRP) methodology.
HRP combines hierarchical clustering with risk-based allocation to create
diversified portfolios that don't rely on unstable correlation matrix inversions.
}
\details{
The HRP algorithm:
\enumerate{
\item Calculate returns from input prices
\item Compute covariance matrix from returns
\item Cluster assets based on distance matrix
\item Apply recursive bisection with inverse variance weighting
\item Results in naturally diversified portfolio without matrix inversion
}

The function accepts price data and calculates returns internally,
matching the pattern of other library functions like calc_momentum().
}
\examples{
data("sample_prices_daily")
data("sample_prices_weekly")
# Create a selection first
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, n = 10)

# Using daily prices for risk calculation
weights <- weight_by_hrp(selected, sample_prices_daily, lookback_periods = 252)

# Using correlation-based clustering
weights <- weight_by_hrp(selected, sample_prices_daily, use_correlation = TRUE)
}
