% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/technical_indicators.R
\name{calc_momentum}
\alias{calc_momentum}
\title{Calculate Price Momentum}
\usage{
calc_momentum(data, lookback = 12)
}
\arguments{
\item{data}{A data.frame or data.table with Date column and price columns}

\item{lookback}{Number of periods for momentum calculation (default: 12)}
}
\value{
Data.table with momentum values (0.1 = 10\% increase)
}
\description{
Calculates momentum as the percentage change in price over a specified
lookback period. Optimized using column-wise operations (25x faster).
}
\examples{
data("sample_prices_weekly")
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
}
