% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_fill_pretty_c.R
\name{scale_fill_pretty_c}
\alias{scale_fill_pretty_c}
\title{Plotting with PrettyCols palettes for colour ggplot2}
\usage{
scale_fill_pretty_c(palette, direction = 1, legend_title = NULL, ...)
}
\arguments{
\item{palette}{Name of Palette. Run \code{names(PrettyColsPalettes)} to view options.}

\item{direction}{Sets order of colors. Default palette is 1. If direction is -1,
palette color order is reversed}

\item{legend_title}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Deprecated in favour of \code{name}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2]{scale_fill_gradientn}}}
}
\value{
A ggproto object defining a continuous fill scale for use with ggplot2.
}
\description{
Plotting with PrettyCols palettes for colour ggplot2
}
\examples{
library(ggplot2)
ggplot(data = mtcars, aes(x = mpg, y = disp, fill = wt)) +
  geom_point(pch = 21) +
  scale_fill_pretty_c("Greens")
}
