% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_members_chamber_congress.R
\name{list_members_chamber_congress}
\alias{list_members_chamber_congress}
\title{To get a list of members of a particular chamber in a particular Congress}
\usage{
list_members_chamber_congress(congress, chamber, page = 1, myAPI_Key)
}
\arguments{
\item{congress}{102-118 for House, 80-118 for Senate}

\item{chamber}{house or senate}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
list of members of a particular chamber in a particular Congress
}
\description{
The results include all members who have served in that congress and chamber, including members who are no longer in office. HTTP Request: GET https://api.propublica.org/congress/v1/{congress}/{chamber}/members.json
}
\examples{
\dontrun{
list_members_chamber_congress(115, 'senate')
}
}
