% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.R
\name{info}
\alias{info}
\alias{note}
\title{Extract info or note parts of the comment attribute}
\usage{
info(x)

note(x)
}
\arguments{
\item{x}{Object with a \code{comment} attribute.}
}
\value{
\itemize{
\item \code{note()} returns all elements in the \code{comment} attribute that originate from
the \emph{note} field. The \code{"note"} name is then removed.
\item \code{info()} returns the remaining elements in the \code{comment} attribute.
}
}
\description{
The functions \code{info()} and \code{note()} provide access to
different parts of an object's comment attribute,
which is accessed by \code{comment()}.
}
\details{
The \code{comment} attribute is assumed to be derived from JSON-stat2 metadata,
where some elements originate from text in a \emph{note} field.

The \code{comment} attribute of data downloaded by the package is
constructed by
\verb{c(unlist(obj[c("label", "source", "updated")]),}
\verb{unlist(obj$extension$px[c("tableid", "contents")]),}
\verb{unlist(obj["note"]))}

where \code{obj} is a list containing the JSON-stat2 metadata.
Thus, possible none-existing elements are ignored.
}
