% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensure_json_stat2.R
\name{ensure_json_stat2}
\alias{ensure_json_stat2}
\title{Ensure JSON-stat2 output format in PxWebApi v2 URLs}
\usage{
ensure_json_stat2(url)
}
\arguments{
\item{url}{A character string of length one giving a PxWebApi v2 data URL.}
}
\value{
A character string with \code{outputFormat=json-stat2} enforced.
}
\description{
Ensures that a PxWebApi v2 URL requests data in JSON-stat2 format by enforcing
\code{outputFormat=json-stat2}.
}
\details{
The function behaves as follows:
\itemize{
\item If the URL already contains \code{outputFormat=json-stat2}, it is
returned unchanged.
\item If the URL contains an \code{outputFormat} parameter with another
value (e.g. \code{csv}), only the value is replaced by
\code{json-stat2}, leaving the rest of the URL unchanged.
\item If the URL does not contain any \code{outputFormat} parameter,
\code{outputFormat=json-stat2} is appended.
}

Matching of parameter names and values is case-insensitive, but the resulting
URL always uses the canonical camelCase form
\code{outputFormat=json-stat2}.

This function is intended for internal use to guarantee a consistent and
standardized output format across different PxWebApi v2 providers.
}
\note{
This function is written and documented with help from ChatGPT.
}
\examples{
url1 <- "https://api.no/data?lang=en"
url1
ensure_json_stat2(url1)

url2 <- paste0(url1, "&valueCodes[Tid]=top(2)")
url2
ensure_json_stat2(url2)

url3 <- paste0(url1, "&outputFormat=csv&valueCodes[Tid]=?")
url3
ensure_json_stat2(url3)
}
\keyword{internal}
