% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brapi.R
\name{get_qbms_connection}
\alias{get_qbms_connection}
\title{Get the QBMS Connection}
\usage{
get_qbms_connection()
}
\value{
A list containing the current QBMS configuration and state.
}
\description{
Retrieves the current QBMS connection object, which contains the server's configuration 
and state, including any active sessions and tokens. This can be used to save and restore 
connections between sessions.
}
\examples{
if(interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  
  login_bms()
  set_crop("wheat")
  set_program("Wheat International Nurseries")
  
  df1  <- get_germplasm_data("Jabal")
  con1 <- get_qbms_connection()
  
  set_qbms_config("https://gigwa.southgreen.fr/gigwa/", engine = "gigwa", no_auth = TRUE)
  
  gigwa_set_db("DIVRICE_NB")
  gigwa_set_project("refNB")
  gigwa_set_run("03052022")
  
  df2  <- gigwa_get_metadata()
  con2 <- get_qbms_connection()
  
  set_qbms_connection(con1)
  df3 <- get_germplasm_attributes("Jabal")
}

}
\seealso{
\code{\link{set_qbms_connection}}
}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
