% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{list_programs}
\alias{list_programs}
\title{Retrieve Breeding Programs for the Active Crop}
\usage{
list_programs()
}
\value{
A data frame containing the names of breeding programs available for the active crop.
}
\description{
Retrieves the list of breeding programs available for the currently selected crop. 
The crop must be set using the \code{\link{set_crop}} function prior to calling this.
}
\examples{
if (interactive()) {
  set_qbms_config("https://bms.icarda.org/ibpworkbench")
  login_bms()  # Log in to the server
  set_crop("wheat")  # Set "wheat" as the active crop
  list_programs()  # Retrieve breeding programs for the active crop
}

}
\seealso{
\code{\link{login}}, \code{\link{set_crop}}, \code{\link{list_crops}} for managing server connection and crop selection.
}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
