% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brapi.R
\name{set_qbms_config}
\alias{set_qbms_config}
\title{Configure BMS Server Settings}
\usage{
set_qbms_config(
  url = "http://localhost",
  path = NULL,
  page_size = 1000,
  time_out = 120,
  no_auth = FALSE,
  engine = "bms",
  brapi_ver = "v1",
  verbose = TRUE
)
}
\arguments{
\item{url}{The URL of the BMS login page or API base (default is "http://localhost").}

\item{path}{The API path to use (default is NULL, which sets a path based on the engine).}

\item{page_size}{The number of records per page when making API calls (default is 1000).}

\item{time_out}{The maximum number of seconds to wait for a response (default is 120).}

\item{no_auth}{Logical, whether the server requires authentication (default is FALSE).}

\item{engine}{The backend system (default is "bms"). Options include "bms", "gigwa", "breedbase", "ebs", "germinate".}

\item{brapi_ver}{The version of BrAPI to use, either "v1" or "v2" (default is "v1").}

\item{verbose}{Logical, indicating whether to display progress information when making API calls (default is TRUE).}
}
\value{
No return value.
}
\description{
Configures the BMS server connection settings, including URL, API path, page size, and timeout.
This function allows you to set up the connection for different server backends like BMS, Gigwa, 
EBS, and Breedbase, and choose the appropriate BrAPI version.
}
\examples{
set_qbms_config("https://bms.icarda.org/ibpworkbench")

}
\author{
Khaled Al-Shamaa (\email{k.el-shamaa@cgiar.org})
}
