% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Chooser.R
\name{ChooserLT}
\alias{ChooserLT}
\title{Chooser option valuation via Lattice Tree (LT) Model}
\usage{
ChooserLT(o = OptPx(Opt("Chooser", ttm = 1)), t1 = 0.5, t2 = 0.5,
  IncBT = FALSE)
}
\arguments{
\item{o}{The \code{OptPx} option object to price.}

\item{t1}{The time to maturity of the call option, measured in years.}

\item{t2}{The time to maturity of the put option, measured in years.}

\item{IncBT}{\code{TRUE/FALSE} Choice of including the lattice tree simulation in the output.
Input \code{FALSE} yields faster computation and fewer calculated results to store in memory.}
}
\value{
An original \code{OptPx} object with \code{PxLT} field as the price of the option and user-supplied \code{ttc},
\code{IncBT} parameters attached.
}
\description{
Calculates the price of a Chooser option using a recombining binomial tree model.
Has pricing capabilities for both simple European Chooser options
as well as American Chooser Options, where exercise can occur any time as a call or put options.
}
\details{
The American chooser option is interpreted as exercise of option being available
at any point in time during the life of the option.
}
\examples{
(o = ChooserLT())$PxLT    #Default Chooser option price. (See Ho pg 234 in references)

o = Opt('Eu', S0=100, ttm=1, K=100)
o = OptPx(o, r=0.10, q=0, vol=0.1, NSteps=5)
(o = ChooserLT(o, t1 = .5, t2 =.5, IncBT=TRUE))$PxLT

#American Chooser, higher price than European equivalent
o = Opt('Am', S0=100, ttm=1, K=100)
o = OptPx(o, r=0.10, q=0, vol=0.1, NSteps=5)
ChooserLT(o,t1=.5, t2=.5,IncBT=FALSE)$PxLT

o = Opt('Eu', S0=50, ttm=1, K=50)
o = OptPx(o, r=0.05, q=0.02, vol=0.25, NSteps=5)
ChooserLT(o, t1 = .75, t2 = .75, IncBT=FALSE)$PxLT

o = Opt('Eu', S0=50, ttm=1, K=50)
o = OptPx(o, r=0.05, q=0.5, vol=0.25, NSteps=5)
ChooserLT(o, t1 = .75, t2 = .75, IncBT=FALSE)$PxLT
}
\author{
Richard Huang, Department of Statistics, Rice University, spring 2015
}
\references{
Hull, J.C., \emph{Options, Futures and Other Derivatives}, 9ed, 2014. Prentice Hall.
ISBN 978-0-13-345631-8, \url{http://www-2.rotman.utoronto.ca/~hull/ofod/index.html}
\cr Thomas S.Y. Ho et al., \emph{The Oxford Guide to Financial Modeling : Applications for Capital Markets. . .}
}

