% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.R
\name{get_R_theta}
\alias{get_R_theta}
\title{Get R and Theta Values from Summary File}
\usage{
get_R_theta(cleaned_summary, atan = FALSE)
}
\arguments{
\item{cleaned_summary}{A summary object from the clean_summary function.}

\item{atan}{Logical. If TRUE, calculates theta using atan2.}
}
\value{
A list containing the following elements:
  - `R_all`: A data frame where each row corresponds to a marker, and columns represent total signal intensity (R) values for each sample.
  - `theta_all`: A data frame where each row corresponds to a marker, and columns represent allelic ratio (theta) values for each sample.
  - Both data frames include a `MarkerName` column as the first column, which contains marker identifiers.
}
\description{
This function calculates R and theta values from a cleaned summary file. 
It optionally performs standard normalization by plate and markers.
}
