% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.R
\name{read_axiom}
\alias{read_axiom}
\title{Convert Axiom Array Summary File to Qploidy Input}
\usage{
read_axiom(summary_file, ind_names = NULL, atan = FALSE)
}
\arguments{
\item{summary_file}{Path to the Axiom summary file.}

\item{ind_names}{Optional. A file with two columns: Plate_name (sample IDs 
in the summary file) and Sample_Name (desired sample names).}

\item{atan}{Logical. If TRUE, calculates theta using atan2.}
}
\value{
A data frame formatted for Qploidy analysis, containing the following columns:
  - `MarkerName`: Marker identifiers.
  - `SampleName`: Sample identifiers (if `ind_names` is provided, these will be updated accordingly).
  - `X`: Reference allele intensity (calculated if applicable).
  - `Y`: Alternative allele intensity (calculated if applicable).
  - `R`: Total signal intensity (calculated if applicable).
  - `ratio`: Allelic ratio (theta, calculated if applicable).
  - Additional columns may be included depending on the input data and processing steps.
}
\description{
This function processes an Axiom array summary file and converts it into a 
format compatible with Qploidy and fitpoly analysis.
}
