% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demean.R
\name{demean}
\alias{demean}
\title{Demeaning Variables}
\usage{
demean(X, Glist, separate = FALSE, drop = NULL)
}
\arguments{
\item{X}{A matrix or vector to demean.}

\item{Glist}{The adjacency matrix. For networks consisting of multiple subnets (e.g., schools), \code{Glist} must be a list of subnets, with the \code{m}-th element being an \eqn{n_m \times n_m} adjacency matrix, where \eqn{n_m} is the number of nodes in the \code{m}-th subnet.}

\item{separate}{A logical value specifying whether variables should be demeaned separately for isolated and non-isolated individuals.
This is similar to setting \code{fixed.effects = "separate"} in \code{\link{qpeer}}.}

\item{drop}{A logical vector of the same length as the sample, indicating whether an observation should be dropped.
This can be used, for example, to remove false isolates or to estimate the model only on non-isolated agents.
These observations cannot be directly removed from the network by the user, as they may still be connected to other agents.}
}
\value{
A matrix or vector with the same dimensions as \code{X}, containing the demeaned values.
}
\description{
\code{demean} demeans variables by subtracting the within-subnetwork average. In each subnetwork, this transformation can be performed separately
for isolated and non-isolated nodes.
}
