% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_parsers.R
\name{read_file}
\alias{read_file}
\title{Call the appropriate function required to read a table file and return the table as a dataframe object.}
\usage{
read_file(filename, csvsep = ";", dec = ".", sheet = 1)
}
\arguments{
\item{filename}{(Character) Name or path of the table file to read. Can be of type CSV, XLS, XLSX, TSV, or TXT.}

\item{csvsep}{(Character) separator used in CSV file (ignored for other file types).}

\item{dec}{(Character) decimal separator used in CSV, TSV and TXT files.}

\item{sheet}{(Numeric or Character) Number or name of a sheet in XLS or XLSX files (\emph{optional}). Default: \code{";"}}
}
\value{
A dataframe object with headers in the first row.
}
\description{
\code{read_file} automatically detects the format of a file provided as \code{filename} and calls the appropriate function to read the table file.
}
\examples{
input <- read_file(filename = system.file("2-FMA_toxicity.csv", package = "QurvE"), csvsep = ";" )

}
