% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twosample_test_adjusted_pvalue.R
\name{twosample_test_adjusted_pvalue}
\alias{twosample_test_adjusted_pvalue}
\title{Adjusted p values for simultaneous testing in the two-sample problem.}
\usage{
twosample_test_adjusted_pvalue(
  x,
  y,
  vals = NA,
  TS,
  TSextra,
  wx = rep(1, length(x)),
  wy = rep(1, length(y)),
  B = c(5000, 1000),
  nbins = c(50, 10),
  minexpcount = 5,
  samplingmethod = "independence",
  rnull,
  SuppressMessages = FALSE,
  doMethods
)
}
\arguments{
\item{x}{a vector of numbers if data is continuous or of counts  if data is discrete, or a list with the data.}

\item{y}{a vector of numbers if data is continuous or of counts  if data is discrete.}

\item{vals}{=NA, a vector of numbers, the values of a discrete random variable. NA if data is continuous data.}

\item{TS}{routine to calculate test statistics for non-chi-square tests}

\item{TSextra}{additional info passed to TS, if necessary}

\item{wx}{A numeric vector of weights of x.}

\item{wy}{A numeric vector of weights of y.}

\item{B}{=c(5000, 1000), number of simulation runs for permutation test}

\item{nbins}{=c(50,10), number of bins for chi square tests.}

\item{minexpcount}{= 5, minimum required expected counts for chi-square tests}

\item{samplingmethod}{="independence" or "Binomial" for discrete data}

\item{rnull}{routine for parametric bootstrap}

\item{SuppressMessages}{= FALSE print informative messages?}

\item{doMethods}{="all" a vector of codes for the methods to include. If "all", all methods are used.}
}
\value{
A list of two numeric vectors, the test statistics and the p values.
}
\description{
This function runs a number of two sample tests using Rcpp and parallel computing and then finds the correct p value for the combined tests.
}
\details{
For details consult vignette("R2sample","R2sample")
}
\examples{
 x=rnorm(100)
 y=rt(200, 4)
 R2sample::twosample_test_adjusted_pvalue(x, y, B=c(500, 500))
 vals=1:5
 x=table(c(1:5, sample(1:5, size=100, replace=TRUE)))-1
 y=table(c(1:5, sample(1:5, size=100, replace=TRUE, prob=c(1,1,3,1,1))))-1
 R2sample::twosample_test_adjusted_pvalue(x, y, vals, B=c(500, 500))
}
