% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortC.r
\name{sortC}
\alias{sortC}
\title{Sorts dataset observations by user-defined criteria to return case-level information}
\usage{
sortC(id, by, data, thenby, descending = TRUE, limit, confirm = TRUE,
  printC = FALSE)
}
\arguments{
\item{id}{A variable in the dataset (data) that identfies individual cases, typically the name of states, countries, etc.}

\item{by}{Variable the cases should be sorted by.}

\item{data}{(Optional) Dataset to be sorted.}

\item{thenby}{(Optional) Criteria for sorting cases after sorting with the "by" variable. Useful if many cases tied on first criteria.}

\item{descending}{(Optional) Should the cases be sorted in descending order?  By default, set to TRUE. When sorting ordered factors, check that the levels higher numerically correspond to the sort order you have in mind.}

\item{limit}{(Optional) The number of rows to report. If there are many observations to be sorted, you may want to limit output to 5, 10, etc. rows.}

\item{confirm}{(Optional) If function is going to return long table of results (more than 20 rows), you'll be asked for confirmation (use \code{confirm=F} to bypass).}

\item{printC}{(Optional) Do you want to print table of sorted observations to to .html file in working directory? (default: FALSE)}
}
\value{
A data frame of sorted observations.
}
\description{
Returns case-level information in order specified by user. You can sort by additional criteria to break ties. Useful for learning about units of analysis and selecting cases for qualitative research designs.
}
\section{RCPA3 Package Tutorial Videos}{

\itemize{
\item \href{https://www.youtube.com/watch?v=xdnaFE3kWeU}{Sort and View Case-Level Information with the sortC Function} 12:22
\item \href{https://www.youtube.com/playlist?list=PL3jY4WDTUxoNqrxSSQH4q7XPLPYipeNCu}{Complete Playlist of RCPA3 Package Tutorial Videos}, includes video for this function and many more.
}
}

\section{Textbook References}{

\itemize{
\item Philip H. Pollock and Barry C. Edwards, \emph{An R Companion to Political Analysis, 3rd Edition} (Thousand Oaks, CA: Sage Publications, Forthcoming 2022), Chapters 2, 6.
\item Philip H. Pollock and Barry C. Edwards, \emph{The Essentials of Political Analysis, 6th Edition} (Thousand Oaks, CA: Sage Publications, 2020), pp. 122-123. ISBN-13: 978-1506379616; ISBN-10: 150637961.
}
}

\section{Online Resources}{

\itemize{
\item \href{https://www.poliscidata.com/pages/rDemosResources.php?chapter=2}{R Tutorials & Resources for Descriptive Statistics}, compiled by Barry C. Edwards
\item \href{https://edge.sagepub.com/pollock}{Sage Edge Resources for Political Analysis Series}, for streaming videos, flashcards, and more student resources for textbooks by Pollock and Edwards, from Sage Publications.
\item \href{https://www.poliscidata.com}{Political Science Data Web Site}: Find datasets for your own research and resources to help with the analysis.
}
}

\examples{
   library(RCPA3)
   
   # basic usage
   sortC(id=state, by=abortlaws, data=states)
   
\dontrun{
   # options to limit results and sort in ascending order
   sortC(id=country, by=gini.index, descending=FALSE, limit=10, data=world)
   
   # sort by and thenby 
   sortC(id=country, by=vdem.4cat, thenby=gini.index, descending=c(FALSE, FALSE), 
         data=world, confirm=FALSE)
   sortC(id=country, by=vdem.4cat, thenby=gini.index, descending=c(FALSE, TRUE), 
         data=world, confirm=FALSE)
 }
}
