% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_IFE_algorithm_functions.R
\name{calculate_sigma2maxmodel}
\alias{calculate_sigma2maxmodel}
\title{Calculates sigma2maxmodel}
\usage{
calculate_sigma2maxmodel(e, kg_max, S, S_cand, kg, k, k_cand)
}
\arguments{
\item{e}{NxT-matrix containing the estimated error term}

\item{kg_max}{scalar: maximum allowed number of estimated factors for any group}

\item{S}{estimated number of groups}

\item{S_cand}{vector with candidate values for the number of groups}

\item{kg}{vector with the estimated number of group specific factors for each group}

\item{k}{estimated number of common factors}

\item{k_cand}{vector with candidate value for the number of common factors}
}
\value{
numeric
}
\description{
Sigma2 is the sum of the squared errors, divided by NT. We need the sigma2 of the maxmodel to use (in term 2,3,4 of the PIC) instead of the configuration-dependent sigma2. (See paper AndoBai 2016).
sigma2_max_model could actually be set to 1 as well, as it can be absorbed in parameter C of the PIC.
}
