% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/climacell_temperature.R
\name{climacell_temperature}
\alias{climacell_temperature}
\title{Temperature Readings from Climacell}
\usage{
climacell_temperature(
  api_key,
  lat,
  long,
  timestep,
  start_time = NULL,
  end_time = NULL
)
}
\arguments{
\item{api_key}{character string representing the private API key. Provided by user or loaded automatically from environment variable (environment variable must be called "CLIMACELL_API").}

\item{lat}{a numeric value (or a string that can be coerced to numeric) representing the latitude of the location.}

\item{long}{a numeric value (or a string that can be coerced to numeric) representing the longitude of the location.}

\item{timestep}{a 'step' value for the time. Choose one of the following valid values: c('1d', '1h', '30m','15m','5m','1m','current').}

\item{start_time}{the start time of the query. This input must be a character string that can be parsed into a data/time or a date/time value. If the input does not contain a timezone, the value will be assumed to be in UTC. It is recommended that the \code{lubridate::now()} function or \code{Sys.time()} be used to define the start_time. For this function, the start_time cannot be less than 6 hours from the current time.}

\item{end_time}{the end time of the query. This input must be a character string that can be parsed into a data/time or a date/time value. If the input does not contain a timezone, the value will be assumed to be in UTC. OPTIONAL if timestep is 'current' or if the user desires to get the maximum results possible (depends on the timestep chosen).}
}
\value{
a tibble
}
\description{
This function will make a call to the Climacell API and retrieve temperature related variables.
}
\details{
\code{climacell_temperature} returns a tibble that consists of temperature related variables (returned values are in metric units) using the Climacell API. These variables consist of temperature, a "feels like" temperature, dewpoint, and humidity.
}
\examples{
\dontrun{
climacell_temperature(
  api_key = Sys.getenv('CLIMACELL_API'),
  lat = 0,
  long = 0,
  timestep = 'current')
}
}
