% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RDML.AsDendrogram.R
\docType{methods}
\name{RDML.AsDendrogram}
\alias{RDML.AsDendrogram}
\title{Represents structure of \code{RDML} file as dendrogram}
\arguments{
\item{plot.dendrogram}{plots dendrogram if \code{TRUE}}
}
\value{
\code{dendrogram} object
}
\description{
Plots and/or returns the structure of \code{RDML} file as 
\code{\link[stats]{dendrogram}} (tree-like structure.)
}
\examples{
PATH <- path.package("RDML")
filename <- paste(PATH, "/extdata/", "BioRad_qPCR_melt.rdml", sep ="")
cfx96 <- RDML$new(filename)
#plot dendrogram
cfx96$AsDendrogram()
#assign dendrogram to the object
dendr <- cfx96$AsDendrogram(plot.dendrogram = FALSE)
}
\author{
Konstantin A. Blagodatskikh <k.blag@yandex.ru>, Stefan Roediger 
  <stefan.roediger@b-tu.de>, Michal Burdukiewicz 
  <michalburdukiewicz@gmail.com>
}
\keyword{manip}
