% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds2dd_detailed.R
\name{guess_time_only}
\alias{guess_time_only}
\title{Guess time variables based on naming pattern}
\usage{
guess_time_only(
  data,
  validate.time = FALSE,
  time.var.sel.pos = "[Tt]i[d(me)]",
  time.var.sel.neg = "[Dd]at[eo]"
)
}
\arguments{
\item{data}{data.frame or tibble}

\item{validate.time}{Flag to validate guessed time columns}

\item{time.var.sel.pos}{Positive selection regex string passed to
`gues_time_only_filter()` as sel.pos.}

\item{time.var.sel.neg}{Negative selection regex string passed to
`gues_time_only_filter()` as sel.neg.}
}
\value{
data.frame or tibble
}
\description{
This is for repairing data with time variables with appended "1970-01-01"
}
\examples{
redcapcast_data |> guess_time_only(validate.time = TRUE)
}
