% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FA.R
\name{est_num}
\alias{est_num}
\title{Estimating Factor Numbers Corresponding PCA}
\usage{
est_num(X, kmax = 8, type = "BIC3")
}
\arguments{
\item{X}{Input matrix, of dimension \eqn{T\times N}. Each row is an observation with \eqn{N} features at time point \eqn{t}.}

\item{kmax}{The user-supplied maximum factor numbers.}

\item{type}{The method used. Options include "PC1", "PC2", "PC3", "IC1", "IC2", "IC3", "AIC3", "BIC3", "ER", "GR".}
}
\value{
The estimated factor numbers.
}
\description{
Estimating Factor Numbers Corresponding PCA
}
\examples{
\donttest{
dat = gendata()
est_num(dat$Y, kmax = 8, type = "BIC3")
}
}
\author{
Jiaqi Hu
}
