% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_regression_diagnostics.R
\name{calculate_regression_diagnostics}
\alias{calculate_regression_diagnostics}
\title{Calculate regression diagnostics by period}
\usage{
calculate_regression_diagnostics(
  dataset,
  period_variable,
  dependent_variable,
  numerical_variables = NULL,
  categorical_variables = NULL
)
}
\arguments{
\item{dataset}{A data.frame with input data}

\item{period_variable}{Name of the period variable (string)}

\item{dependent_variable}{Name of the dependent variable (string)}

\item{numerical_variables}{Vector of numerical independent variables (default = NULL)}

\item{categorical_variables}{Vector of categorical independent variables (default = NULL)}
}
\value{
A data.frame with diagnostics by period
}
\description{
For each period in the data, fits a log-linear model and computes diagnostics:
\itemize{
\item Normality test (Shapiro-Wilk)
\item Adjusted R-squared
\item Breusch-Pagan test for heteroscedasticity
\item Durbin-Watson test for autocorrelation
}
}
\examples{
diagnostics <- calculate_regression_diagnostics(
  dataset = data_constraxion,
  period_variable = "period",
  dependent_variable = "price",
  numerical_variables = c("floor_area", "dist_trainstation"),
  categorical_variables = c("dummy_large_city", "neighbourhood_code")
)
head(diagnostics)
}
\author{
Mohammad Kardal, Vivek Gajadhar
}
