#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
#+++ R script for deleting debugging code +++
#+++ Code used only for debugging can be written inside dummy functions .tmp.f().
#+++ With this script, these functions will be deleted on loading or sourcing
#+++ the package.
#+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

# Remove debugging code that is encapsulated in .tmp.f function blocks
# (to prevent R check complaints)
.tmp.f <- NULL

# Prevent R CMD check on complaining of unused bindings
if (getRversion() >= "2.15.1") {
	# used in magitr and classes
	utils::globalVariables(c(".", ".self"))
	# used in sEddyProc with <<-
	utils::globalVariables(c("sID", "sDATA", "sINFO", "sLOCATION", "sTEMP", "sUSTAR"))
}

# if (getRversion() >= "3.1.0") {
# 	utils::suppressForeignCheck(c("sID", "sDATA", "sINFO", "sLOCATION", "sTEMP", "sUSTAR")
# 	                              , package = "REddyProc")
# }

# used in sEddyProc methods with <<-
# workaround: define global variables
# do not want to generate Rd files, unfortunately with assign also Rd files are
# generated by inlinedocs
sID <- sDATA <- sINFO <- sLOCATION <- sTEMP <- sUSTAR_DETAILS <- sUSTAR <- sUSTAR_SCEN <-
  "globalsREddyProcDummyToSatisfyRCMDcheck"

.genDeprecatedCheckCode <- function(
  ### generate expanded working code for map_lgl(varNamesDepr, missing)
  varNamesDepr
){
  #from twDev
  copy2clip <- function(
    x, col.names = NA, row.names = FALSE, quote = FALSE,
    sep = "\t", ..., selection = c("clipboard", "primary", "secondary")
  ) {
    if (.Platform$OS.type == "unix") {
      if (!isTRUE(file.exists(Sys.which("xclip")[1L])))
        stop("Cannot find xclip")
      selection <- match.arg(selection)[1L]
      con <- pipe(paste0("xclip -i -selection ", selection),"w")
      on.exit(close(con))
      write.table(x, con, sep = sep, row.names = row.names,
                  col.names = row.names, quote = quote, ...)
    } else {
      write.table(x, "clipboard", sep = sep, row.names = row.names,
                  col.names = row.names, quote = quote, ...)
    }
    x
  }
  copy2clip(paste0(
    "iDepr = which(!c("
    , paste(paste0("missing(", varNamesDepr,")"), collapse = ",")
    , "))"))
}
