% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ch22}
\alias{ch22}
\title{ch22 importance values}
\format{
A list
\describe{
\item{imp}{importaces }
\item{C}{table of counts}
}
}
\source{
A Global Reference for Human Genetic Variation, Auton et al., Nature, 2015, 526:7571 pp 68--74
}
\usage{
ch22
}
\description{
A dataset containing  1103547 importance values, and a table of variables used in splits.
Note that the importances have not been logged.
}
\examples{
\dontrun{
library(ranger)
system.time(fit.ranger.7 <- ranger(dependent.variable.name= "V1", data = aa2,
                                importance = "impurity",
                                 num.threads=20,num.trees = 100000,
                                 seed=123))
#Ranger result
#Call:
#ranger(dependent.variable.name = "V1", data = aa2, importance = "impurity", 
#                              num.threads = 20, num.trees = 1e+05, seed = 123) 
#Type:                             Classification 
#Number of trees:                  1e+05 
#Sample size:                      2504 
#Number of independent variables:  1103547 
#Mtry:                             1050 
#Target node size:                 1 
#Variable importance mode:         impurity 
#Splitrule:                        gini 
#OOB prediction error:             4.27 \%
C <-count_variables(fit.ranger.7)
imp<-rf1$variable.importance

ch22<-list(imp,C)
names(ch22)<-c("imp","C")
}

data(ch22)

}
\keyword{datasets}
