% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_space.R
\name{initializeExo}
\alias{initializeExo}
\title{Initialization of exogenous variables}
\usage{
initializeExo(varNames, D = NULL, L = NULL)
}
\arguments{
\item{varNames}{A \code{(k x 1)} character vector containing the names of the exogenous
variables.}

\item{D}{A \code{(n x k)} matrix containing the difference transformations, see details.}

\item{L}{A \code{(n x k)} matrix containing the lag transformations, see details.}
}
\value{
An array of size \code{(n, k, 2)}. The \code{[, , 1]} specifies
  the difference order and \code{[, , 2]} the lag order.
}
\description{
Initializes the transformations applied to exogenous variables.
}
\details{
For the matrices \code{D} and \code{L}, the rows denote different transformations 
  to each of the variables in the columns. \code{NA} indicates no transformation.
}
