/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.AsymmetricEndPoints;
import ec.satoolkit.x11.DefaultTrendFilteringStrategy;
import ec.satoolkit.x11.DefaultX11Algorithm;
import ec.satoolkit.x11.ITrendCycleComputer;
import ec.satoolkit.x11.MusgraveFilterFactory;
import ec.satoolkit.x11.TrendCycleFilterFactory;
import ec.satoolkit.x11.X11Step;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.timeseries.simplets.TsData;

class DefaultTrendCycleComputer
extends DefaultX11Algorithm
implements ITrendCycleComputer {
    private final SymmetricFilter hendersonFilter;

    DefaultTrendCycleComputer(int hLength) {
        this.hendersonFilter = TrendCycleFilterFactory.makeHendersonFilter(hLength);
    }

    @Override
    public TsData doFinalFiltering(X11Step step, TsData s, InformationSet info) {
        int flen = this.hendersonFilter.getLength();
        DefaultTrendFilteringStrategy strategy = new DefaultTrendFilteringStrategy(this.hendersonFilter, new AsymmetricEndPoints(MusgraveFilterFactory.makeFiltersForHenderson(flen, this.context.getFrequency())), flen + "-Henderson");
        if (step == X11Step.D) {
            info.subSet("d-tables").set("d12filter", strategy.getDescription());
            info.subSet("d-tables").set("tlen", Integer.valueOf(flen));
        }
        return strategy.process(s, s.getDomain());
    }

    @Override
    public TsData doInitialFiltering(X11Step step, TsData s, InformationSet info) {
        SymmetricFilter trendFilter = TrendCycleFilterFactory.makeTrendFilter(this.context.getFrequency());
        return new DefaultTrendFilteringStrategy(trendFilter, null).process(s, s.getDomain());
    }

    public int getFilterLength() {
        return this.hendersonFilter.getLength();
    }
}

