/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.sarima;

import ec.tstoolkit.arima.AbstractArimaModel;
import ec.tstoolkit.arima.ArimaException;
import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.StationaryTransformation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.maths.linearfilters.Utilities;
import ec.tstoolkit.maths.polynomials.Polynomial;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.SarmaSpecification;

public class SarimaModel
extends AbstractArimaModel
implements IArimaModel,
Cloneable {
    private static final double EPS = 1.0E-6;
    private double[] params_;
    private SarimaSpecification spec_;

    private SarimaModel() {
    }

    public SarimaModel(SarimaSpecification spec) {
        this.spec_ = spec.clone();
        this.params_ = new double[spec.getParametersCount()];
        this.setDefault();
    }

    public SarimaModel(SarimaSpecification spec, double[] parameters) throws ArimaException {
        if (parameters.length != spec.getParametersCount()) {
            throw new ArimaException("arima_err_invalid");
        }
        this.spec_ = spec.clone();
        this.params_ = (double[])parameters.clone();
    }

    public SarimaModel(SarmaSpecification spec) {
        this.spec_ = new SarimaSpecification(spec);
        this.params_ = new double[spec.getParametersCount()];
        this.setDefault();
    }

    public boolean adjustSpecification() throws ArimaException {
        int bq;
        int q;
        int bp;
        int p;
        boolean rslt = false;
        for (int i = p = this.spec_.getP(); i > 0 && Math.abs(this.phi(i)) < 1.0E-6; --i) {
            --p;
            rslt = true;
        }
        for (int i = bp = this.spec_.getBP(); i > 0 && Math.abs(this.bphi(i)) < 1.0E-6; --i) {
            --bp;
            rslt = true;
        }
        for (int i = q = this.spec_.getQ(); i > 0 && Math.abs(this.theta(i)) < 1.0E-6; --i) {
            --q;
            rslt = true;
        }
        for (int i = bq = this.spec_.getBQ(); i > 0 && Math.abs(this.btheta(i)) < 1.0E-6; --i) {
            --bq;
            rslt = true;
        }
        if (rslt) {
            int k;
            SarimaSpecification spec = this.spec_.clone();
            spec.setP(p);
            spec.setBP(bp);
            spec.setQ(q);
            spec.setBQ(bq);
            double[] nparams = new double[spec.getParametersCount()];
            int i = 0;
            int j = 0;
            for (k = 0; k < p; ++k) {
                nparams[j++] = this.params_[i++];
            }
            i += this.spec_.P - p;
            for (k = 0; k < bp; ++k) {
                nparams[j++] = this.params_[i++];
            }
            i += this.spec_.BP - bp;
            for (k = 0; k < q; ++k) {
                nparams[j++] = this.params_[i++];
            }
            i += this.spec_.Q - q;
            for (k = 0; k < bq; ++k) {
                nparams[j++] = this.params_[i++];
            }
            this.spec_ = spec;
            this.params_ = nparams;
            this.clearCachedObjects();
        }
        return rslt;
    }

    public double bphi(int lag) throws ArimaException {
        if (lag <= 0 || lag > this.spec_.getBP()) {
            throw new ArimaException("sarima_err_out");
        }
        return this.params_[this.spec_.getP() + lag - 1];
    }

    public double btheta(int lag) throws ArimaException {
        if (lag <= 0 || lag > this.spec_.getBQ()) {
            throw new ArimaException("sarima_err_out");
        }
        return this.params_[this.spec_.getP() + this.spec_.getBP() + this.spec_.getQ() + lag - 1];
    }

    @Override
    public SarimaModel clone() {
        SarimaModel model = (SarimaModel)super.clone();
        model.spec_ = this.spec_.clone();
        model.params_ = (double[])this.params_.clone();
        return model;
    }

    @Override
    public BackFilter getAR() {
        BackFilter df = this.spec_.getDifferencingFilter();
        BackFilter st = this.getStationaryAR();
        return df.times(st);
    }

    @Override
    public int getARCount() {
        int n = this.spec_.getP() + this.spec_.getD();
        if (this.spec_.getFrequency() != 1) {
            n += this.spec_.getFrequency() * (this.spec_.getBP() + this.spec_.getBD());
        }
        return n;
    }

    public int getDifferenceOrder() {
        int n = this.spec_.getD();
        if (this.spec_.getFrequency() > 1) {
            n += this.spec_.getFrequency() * this.spec_.getBD();
        }
        return n;
    }

    public int getFrequency() {
        return this.spec_.getFrequency();
    }

    @Override
    public double getInnovationVariance() {
        return 1.0;
    }

    @Override
    public BackFilter getMA() {
        Polynomial pr = this.getRegularMA();
        Polynomial ps = this.seasonalMA();
        return new BackFilter(pr.times(ps, false));
    }

    @Override
    public int getMACount() {
        int n = this.spec_.getQ();
        if (this.spec_.getFrequency() != 1) {
            n += this.spec_.getFrequency() * this.spec_.getBQ();
        }
        return n;
    }

    @Override
    public BackFilter getNonStationaryAR() {
        return this.spec_.getDifferencingFilter();
    }

    @Override
    public int getNonStationaryARCount() {
        int n = this.spec_.getD();
        if (this.spec_.getFrequency() != 1) {
            n += this.spec_.getFrequency() * this.spec_.getBD();
        }
        return n;
    }

    public double getParameter(int idx) {
        return this.params_[idx];
    }

    public IReadDataBlock getParameters() {
        return new ReadDataBlock(this.params_);
    }

    public int getParametersCount() {
        return this.params_ == null ? 0 : this.params_.length;
    }

    public Polynomial getRegularAR() {
        double[] p = Polynomial.Doubles.fromDegree(this.spec_.getP());
        p[0] = 1.0;
        for (int i = 0; i < this.spec_.getP(); ++i) {
            p[i + 1] = this.params_[i];
        }
        return Polynomial.of(p);
    }

    public int getRegularDifferenceOrder() {
        return this.spec_.getD();
    }

    public int getRegularAROrder() {
        return this.spec_.P;
    }

    public int getRegularMAOrder() {
        return this.spec_.Q;
    }

    public Polynomial getRegularMA() {
        double[] p = Polynomial.Doubles.fromDegree(this.spec_.getQ());
        p[0] = 1.0;
        int i0 = this.spec_.getP() + this.spec_.getBP();
        for (int i = 0; i < this.spec_.getQ(); ++i) {
            p[i + 1] = this.params_[i0 + i];
        }
        return Polynomial.of(p);
    }

    public Polynomial getSeasonalAR() {
        double[] p = Polynomial.Doubles.fromDegree(this.spec_.getBP());
        p[0] = 1.0;
        int i0 = this.spec_.getP();
        for (int i = 0; i < this.spec_.getBP(); ++i) {
            p[i + 1] = this.params_[i0 + i];
        }
        return Polynomial.of(p);
    }

    private Polynomial seasonalAR() {
        if (this.spec_.BP == 0) {
            return Polynomial.ONE;
        }
        int i0 = this.spec_.P;
        int freq = this.spec_.frequency;
        if (this.spec_.BP == 1) {
            return Polynomial.factor(-this.params_[i0], freq);
        }
        double[] p = Polynomial.Doubles.fromDegree(this.spec_.BP * freq);
        p[0] = 1.0;
        int i = freq;
        int j = i0;
        while (i < this.spec_.BP) {
            p[i] = this.params_[j];
            i += freq;
            ++j;
        }
        return Polynomial.of(p);
    }

    private Polynomial seasonalMA() {
        if (this.spec_.BQ == 0) {
            return Polynomial.ONE;
        }
        int i0 = this.spec_.P + this.spec_.BP + this.spec_.Q;
        int freq = this.spec_.frequency;
        if (this.spec_.BQ == 1) {
            return Polynomial.factor(-this.params_[i0], freq);
        }
        double[] p = Polynomial.Doubles.fromDegree(this.spec_.BQ * freq);
        p[0] = 1.0;
        int i = freq;
        int j = i0;
        while (i < this.spec_.BQ) {
            p[i] = this.params_[j];
            i += freq;
            ++j;
        }
        return Polynomial.of(p);
    }

    public int getSeasonalDifferenceOrder() {
        return this.spec_.getBD();
    }

    public int getSeasonalAROrder() {
        return this.spec_.BP;
    }

    public int getSeasonalMAOrder() {
        return this.spec_.BQ;
    }

    public Polynomial getSeasonalMA() {
        double[] p = Polynomial.Doubles.fromDegree(this.spec_.getBQ());
        p[0] = 1.0;
        int i0 = this.spec_.getP() + this.spec_.getBP() + this.spec_.getQ();
        for (int i = 0; i < this.spec_.getBQ(); ++i) {
            p[i + 1] = this.params_[i0 + i];
        }
        return Polynomial.of(p);
    }

    public SarimaSpecification getSpecification() {
        return this.spec_.clone();
    }

    @Override
    public BackFilter getStationaryAR() {
        Polynomial pr = this.getRegularAR();
        Polynomial ps = this.seasonalAR();
        return new BackFilter(pr.times(ps, true));
    }

    @Override
    public int getStationaryARCount() {
        int n = this.spec_.getP();
        if (this.spec_.getFrequency() != 1) {
            n += this.spec_.getFrequency() * this.spec_.getBP();
        }
        return n;
    }

    @Override
    public boolean isInvertible() {
        return Utilities.checkStability(this.getRegularMA()) && Utilities.checkStability(this.getSeasonalMA());
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public boolean isStable(boolean checkMA) {
        int pos = 0;
        if (this.spec_.P > 0) {
            if (!Utilities.checkStability(new DataBlock(this.params_, pos, pos + this.spec_.P, 1))) {
                return false;
            }
            pos += this.spec_.P;
        }
        if (this.spec_.BP > 0) {
            if (!Utilities.checkStability(new DataBlock(this.params_, pos, pos + this.spec_.BP, 1))) {
                return false;
            }
            pos += this.spec_.BP;
        }
        if (checkMA && this.spec_.Q > 0) {
            if (!Utilities.checkStability(new DataBlock(this.params_, pos, pos + this.spec_.Q, 1))) {
                return false;
            }
            pos += this.spec_.Q;
        }
        return !checkMA || this.spec_.BQ <= 0 || Utilities.checkStability(new DataBlock(this.params_, pos, pos + this.spec_.BQ, 1));
    }

    @Override
    public boolean isStationary() {
        return this.spec_.getD() == 0 && this.spec_.getBD() == 0;
    }

    public boolean isValid(boolean checkMA) {
        Polynomial bq;
        Polynomial q;
        SarimaModel tmp = this.clone();
        tmp.adjustSpecification();
        if (!tmp.isStable(checkMA)) {
            return false;
        }
        Polynomial.SimplifyingTool smp = new Polynomial.SimplifyingTool();
        Polynomial p = tmp.getRegularAR();
        if (smp.simplify(p, q = tmp.getRegularMA())) {
            return false;
        }
        Polynomial bp = tmp.getSeasonalAR();
        return !smp.simplify(bp, bq = tmp.getSeasonalMA());
    }

    public boolean isWhiteNoise() {
        return this.spec_.getParametersCount() == 0 && this.spec_.getD() == 0 && this.spec_.getBD() == 0;
    }

    public double phi(int lag) throws ArimaException {
        if (lag <= 0 || lag > this.spec_.getP()) {
            throw new ArimaException("sarima_err_out");
        }
        return this.params_[lag - 1];
    }

    public void setBPhi(int lag, double val) throws ArimaException {
        if (lag <= 0 || lag > this.spec_.getBP()) {
            throw new ArimaException("sarima_err_out");
        }
        this.params_[this.spec_.getP() + lag - 1] = val;
        this.clearCachedObjects();
    }

    public void setBTheta(int lag, double val) throws ArimaException {
        if (lag <= 0 || lag > this.spec_.getBQ()) {
            throw new ArimaException("sarima_err_out");
        }
        this.params_[this.spec_.getP() + this.spec_.getBP() + this.spec_.getQ() + lag - 1] = val;
        this.clearCachedObjects();
    }

    public final void setDefault() {
        this.setDefault(-0.1, -0.2);
    }

    public final void setDefault(double ar, double ma) {
        int i;
        int i0 = 0;
        int i1 = this.spec_.getP() + this.spec_.getBP();
        for (i = i0; i < i1; ++i) {
            this.params_[i] = ar;
        }
        i0 = i1;
        i1 = this.params_.length;
        for (i = i0; i < i1; ++i) {
            this.params_[i] = ma;
        }
        this.clearCachedObjects();
    }

    public void setParameters(IReadDataBlock val) {
        if (this.params_ == null || val.getLength() != this.params_.length) {
            return;
        }
        val.copyTo(this.params_, 0);
        this.clearCachedObjects();
    }

    public void setPhi(int lag, double val) throws ArimaException {
        if (lag <= 0 || lag > this.spec_.getP()) {
            throw new ArimaException("sarima_err_out");
        }
        this.params_[lag - 1] = val;
        this.clearCachedObjects();
    }

    public void setTheta(int lag, double val) throws ArimaException {
        if (lag <= 0 || lag > this.spec_.getQ()) {
            throw new ArimaException("sarima_err_out");
        }
        this.params_[this.spec_.getP() + this.spec_.getBP() + lag - 1] = val;
        this.clearCachedObjects();
    }

    @Override
    public StationaryTransformation stationaryTransformation() {
        if (this.isStationary()) {
            return new StationaryTransformation(this, BackFilter.ONE);
        }
        BackFilter ur = this.spec_.getDifferencingFilter();
        SarimaModel model = new SarimaModel();
        model.spec_ = new SarimaSpecification(this.spec_.doStationary());
        model.params_ = this.params_;
        return new StationaryTransformation(model, ur);
    }

    public double theta(int lag) throws ArimaException {
        if (lag <= 0 || lag > this.spec_.getQ()) {
            throw new ArimaException("sarima_err_out");
        }
        return this.params_[this.spec_.getP() + this.spec_.getBP() + lag - 1];
    }

    public boolean isAirline(boolean seas) {
        return this.spec_.isAirline(seas);
    }

    public boolean copy(SarimaModel model) {
        int i;
        if (this.spec_.P > model.spec_.P) {
            return false;
        }
        if (this.spec_.BP > model.spec_.BP) {
            return false;
        }
        if (this.spec_.Q > model.spec_.Q) {
            return false;
        }
        if (this.spec_.BQ > model.spec_.BQ) {
            return false;
        }
        for (int i2 = 0; i2 < this.spec_.P; ++i2) {
            this.params_[i2] = model.params_[i2];
        }
        int j = this.spec_.P;
        int k = model.spec_.P;
        for (i = 0; i < this.spec_.BP; ++i) {
            this.params_[i + j] = model.params_[i + k];
        }
        j += this.spec_.BP;
        k += model.spec_.BP;
        for (i = 0; i < this.spec_.Q; ++i) {
            this.params_[i + j] = model.params_[i + k];
        }
        j += this.spec_.Q;
        k += model.spec_.Q;
        for (i = 0; i < this.spec_.BQ; ++i) {
            this.params_[i + j] = model.params_[i + k];
        }
        this.clearCachedObjects();
        return true;
    }

    public int getPhiPosition(int lag) {
        if (this.spec_.P < lag) {
            return -1;
        }
        return lag - 1;
    }

    public int getBPhiPosition(int lag) {
        if (this.spec_.BP < lag) {
            return -1;
        }
        return this.spec_.P + lag - 1;
    }

    public int getThetaPosition(int lag) {
        if (this.spec_.Q < lag) {
            return -1;
        }
        return this.spec_.P + this.spec_.BP + lag - 1;
    }

    public int getBThetaPosition(int lag) {
        if (this.spec_.BQ < lag) {
            return -1;
        }
        return this.spec_.P + this.spec_.BP + this.spec_.Q + lag - 1;
    }
}

