/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.ITaper;

public class TukeyHanningTaper
implements ITaper {
    private double r_;

    public TukeyHanningTaper() {
        this.r_ = 0.1;
    }

    public TukeyHanningTaper(double r) {
        if (r < 0.0 || r > 1.0) {
            throw new IllegalArgumentException();
        }
        this.r_ = r;
    }

    @Override
    public void process(double[] x) {
        double xpi;
        double xtap;
        int l = x.length;
        int len = (int)((double)l * this.r_ * 0.5);
        double twopi = Math.PI * 2;
        int i = 0;
        while (i < len) {
            xtap = ((double)i + 0.5) / (double)l;
            xpi = twopi * xtap / this.r_;
            int n = i++;
            x[n] = x[n] * ((1.0 - Math.cos(xpi)) / 2.0);
        }
        i = x.length - len;
        while (i < x.length) {
            xtap = ((double)i + 0.5) / (double)l;
            xpi = twopi * (1.0 - xtap) / this.r_;
            int n = i++;
            x[n] = x[n] * ((1.0 - Math.cos(xpi)) / 2.0);
        }
    }
}

