/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.polynomials;

import java.util.Arrays;

class IVector
implements Cloneable {
    private static final int g_atom = 4;
    private int[] m_vals;
    private int m_sz;

    public static int simplify(IVector n, IVector d) {
        n.RSort();
        d.RSort();
        int di = 0;
        int ni = 0;
        int ns = 0;
        while (di < d.m_sz && ni < n.m_sz) {
            if (d.m_vals[di] == n.m_vals[ni]) {
                ++ns;
                d.m_vals[di++] = 0;
                n.m_vals[ni++] = 0;
                continue;
            }
            if (n.m_vals[ni] > d.m_vals[di]) {
                ++ni;
                continue;
            }
            ++di;
        }
        if (ns > 0) {
            n.compact();
            d.compact();
        }
        return ns;
    }

    public void add(int s) {
        if (this.m_vals == null) {
            this.m_vals = new int[4];
            this.m_vals[0] = s;
            this.m_sz = 1;
        } else if (this.m_vals.length == this.m_sz) {
            int[] tmp = new int[this.m_sz + 4];
            for (int i = 0; i < this.m_sz; ++i) {
                tmp[i] = this.m_vals[i];
            }
            tmp[this.m_sz++] = s;
            this.m_vals = tmp;
        } else {
            this.m_vals[this.m_sz++] = s;
        }
    }

    public void add(int[] s, int ns) {
        if (this.m_vals != null && this.m_sz + ns <= this.m_vals.length) {
            for (int i = 0; i < ns; ++i) {
                this.m_vals[this.m_sz++] = s[i];
            }
        } else {
            int i;
            int l = this.m_sz + ns;
            l = (1 + l / 4) * 4;
            int[] tmp = new int[l];
            for (i = 0; i < this.m_sz; ++i) {
                tmp[i] = this.m_vals[i];
            }
            for (i = 0; i < ns; ++i) {
                tmp[this.m_sz++] = s[i];
            }
            this.m_vals = tmp;
        }
    }

    public void add(IVector iv) {
        if (iv.m_sz == 0) {
            return;
        }
        this.add(iv.m_vals, iv.m_sz);
    }

    public void clear() {
        this.m_sz = 0;
        this.m_vals = null;
    }

    public IVector clone() {
        try {
            IVector iv = (IVector)super.clone();
            if (this.m_vals != null) {
                iv.m_vals = (int[])this.m_vals.clone();
            }
            return iv;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    private void compact() {
        int j = 0;
        for (int i = 0; i < this.m_sz; ++i) {
            if (this.m_vals[i] == 0) continue;
            this.m_vals[j++] = this.m_vals[i];
        }
        this.m_sz = j;
    }

    private boolean equals(IVector iv) {
        if (this.m_sz != iv.m_sz) {
            return false;
        }
        if (this.m_sz == 0) {
            return true;
        }
        int last = 0;
        for (int i = 0; i < this.m_sz; ++i) {
            int cur = this.m_vals[i];
            if (cur == last) continue;
            int n0 = 0;
            int n1 = 0;
            for (int j = 0; j < this.m_sz; ++j) {
                if (this.m_vals[j] == cur) {
                    ++n0;
                }
                if (iv.m_vals[j] == cur) {
                    ++n1;
                }
                if (n0 == n1) continue;
                return false;
            }
            last = cur;
        }
        return true;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof IVector && this.equals((IVector)obj);
    }

    public int get(int idx) {
        return this.m_vals[idx];
    }

    public int getSize() {
        return this.m_sz;
    }

    public int hashCode() {
        if (this.m_sz == 0) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.m_sz; ++i) {
            n += this.m_vals[i];
        }
        return n;
    }

    public int[] RPowers() {
        if (this.m_sz == 0) {
            return null;
        }
        int n = 1;
        int j = 0;
        for (int i = 1; i < this.m_sz; ++i) {
            if (this.m_vals[i] == this.m_vals[j]) continue;
            ++n;
            j = i;
        }
        int[] rslt = new int[2 * n];
        rslt[0] = this.m_vals[0];
        n = 1;
        int j2 = 0;
        for (int i = 1; i < this.m_sz; ++i) {
            if (this.m_vals[i] != rslt[j2]) {
                rslt[++j2] = n;
                rslt[++j2] = this.m_vals[i];
                n = 1;
                continue;
            }
            ++n;
        }
        rslt[rslt.length - 1] = n;
        return rslt;
    }

    public void RSort() {
        if (this.m_sz == 0) {
            return;
        }
        Arrays.sort(this.m_vals, 0, this.m_sz);
        int n = this.m_sz / 2;
        int i = 0;
        int j = this.m_sz - 1;
        while (i < n) {
            int tmp = this.m_vals[i];
            this.m_vals[i] = this.m_vals[j];
            this.m_vals[j] = tmp;
            ++i;
            --j;
        }
    }

    public IVector sqrt() {
        IVector rslt = new IVector();
        for (int i = 0; i < this.m_sz; i += 2) {
            if (this.m_vals[i] != this.m_vals[i + 1]) {
                return null;
            }
            rslt.add(this.m_vals[i]);
        }
        return rslt;
    }

    public IVector squared() {
        IVector rslt = new IVector();
        if (this.m_sz == 0) {
            return rslt;
        }
        rslt.m_sz = 2 * this.m_sz;
        rslt.m_vals = new int[this.m_vals.length * 2];
        int j = 0;
        for (int i = 0; i < this.m_sz; ++i) {
            rslt.m_vals[j++] = this.m_vals[i];
            rslt.m_vals[j++] = this.m_vals[i];
        }
        return rslt;
    }
}

