% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_jdate_options.R
\name{jdopt_get_options}
\alias{jdopt_get_options}
\title{return package options}
\usage{
jdopt_get_options()
}
\value{
options list that includes DEFAULT_SEPARATOR, VALID_SEPARATORS, MIN_YEAR, MAX_YEAR
}
\description{
get a list of the package options
}
\details{
Package Options have four parts: DEFAULT_SEPARATOR, VALID_SEPARATORS, MIN_YEAR, and
MAX_YEAR. Options are used in validation and type conversion. For example,
if 'VALID_SEPARATORS' part of options include c("/", " "), validation of "1390-01-01"
return FALSE, because separator of this Jalali date is "-" that does not belong to valid
separators set. By default, the conversion of "1000/10/11" to JalaliDate would be failed,
because year of Jalali date should be between 1200 and 1500. By setting 'DEFAULT_SEPARATOR'
to "_", the result of conversion of JalaliDate(1) to character will be "1375_01_02".
}
\examples{
jdopt_get_options()
# $DEFAULT_SEPARATOR
# [1] "/"
#
# $VALID_SEPARATORS
# [1] ""  "-" "/"
#
# $MIN_YEAR
# [1] 1200
#
# $MAX_YEAR
#
# [1] 1500
}
