% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSunlit.R
\name{computeSunlit}
\alias{computeSunlit}
\title{Compute the fraction of sunlit folige given solar position, LAI and G value with the assumption of the symmetric distribution of leaf azimuth angle.}
\usage{
computeSunlit(Theta, G, LAI)
}
\arguments{
\item{Theta}{Solar zenith angle.}

\item{G}{The G value, namely the projection of foliage area.}

\item{LAI}{Leaf area index.}
}
\value{
The fraction of sunlit foliage.
}
\description{
Compute the fraction of sunlit folige given solar position, LAI and G value with the assumption of the symmetric distribution of leaf azimuth angle.
}
\examples{
computeSunlit(30, 0.5, 2.0)

}
\references{
Wang, W. M., Li, Z. L., & Su, H. B. (2007). 
Comparison of leaf angle distribution functions: effects on extinction coefficient and 
fraction of sunlit foliage. Agricultural and Forest Meteorology, 143(1), 106-122.
}
\author{
Wei-Min Wang (wmwang AT gmail.com)
}
