% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EDAS.R
\name{apply.EDAS}
\alias{apply.EDAS}
\title{Function to apply the Evaluation based on Distance from Average Solution (EDAS) method}
\usage{
apply.EDAS(mat, weights)
}
\arguments{
\item{mat}{is a matrix and contains the values for different properties
of different alternatives. Non-beneficial columns need to have negative values}

\item{weights}{are the weights of each property in the decision making process}
}
\value{
the AS_i index from EDAS from which the final ranking can be found
}
\description{
Function to apply the Evaluation based on Distance from Average Solution (EDAS) method
}
\examples{
mat <- matrix(c(250, 200, 300, 275, 225,
16, 16, 32, 32, 16,
12, 8, 16, 8, 16,
5, 3, 4, 4, 2), nrow=5)
colnames(mat)<-c("Price/cost", "Storage Space", "Camera", "Looks")
rownames(mat)<-paste0("Mobile", 1:5)
mat[,"Price/cost"]<--mat[,"Price/cost"]
weights <- c(0.35, 0.25, 0.25, 0.15)
apply.EDAS(mat, weights)
}
