% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMVL.R
\name{mvl_find_matches}
\alias{mvl_find_matches}
\title{Find matching rows}
\usage{
mvl_find_matches(L1, L2, indices1 = NULL, indices2 = NULL)
}
\arguments{
\item{L1}{list of vector like MVL_OBJECTs}

\item{L2}{list of vector like MVL_OBJECTs}

\item{indices1}{list of indices into objects to sort. If absent or NULL it is assumed to be from 1 to the length of the object.}

\item{indices2}{list of indices into objects to sort. If absent or NULL it is assumed to be from 1 to the length of the object.}
}
\value{
A list of matches and match stretches
}
\description{
This function is passed two lists of MVL vectors which are interpreted in data.frame fashion. 
The indices of pairwise matches are returned in order of the arguments ("index1" and "index2"). 
In addition we return indices describing stretches with "index1" value constant ( stretch_index1[i] to stretch_index1[i+1]-1)
}
\examples{
\dontrun{
Mtmp<-mvl_open("tmp_a.mvl", append=TRUE, create=TRUE)
mvl_write_object(Mtmp, data.frame(x=rep(c("a", "b"), 50), y=1:100), "df1")
mvl_write_object(Mtmp, data.frame(x=rep(c("b", "c"), 50), y=21:120), "df2")
Mtmp<-mvl_remap(Mtmp)
L<-mvl_find_matches(list(Mtmp$df1[,"x",ref=TRUE], Mtmp$df1[,"y", ref=TRUE]), 
                        list(Mtmp$df2[,"x",ref=TRUE], Mtmp$df2[,"y", ref=TRUE]))
}
}
\seealso{
\code{\link{mvl_hash_vectors}}, \code{\link{mvl_order_vectors}}, \code{\link{mvl_group}}, \code{\link{mvl_find_matches}}, \code{\link{mvl_indexed_copy}}, \code{\link{mvl_merge}}
}
