% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.RNAmf.R
\name{closed_form_RNA}
\alias{closed_form_RNA}
\title{Closed-form prediction for RNAmf model}
\usage{
closed_form_RNA(fits, x, kernel, XX = NULL, pseudo_yy = NULL)
}
\arguments{
\item{fits}{A fitted GP object from \code{RNAmf}.}

\item{x}{A vector or matrix of new input locations to predict.}

\item{kernel}{A character specifying the kernel type to be used. Choices are \code{"sqex"}(squared exponential kernel), \code{"matern1.5"}(Matern kernel with \eqn{\nu=1.5}), or \code{"matern2.5"}(Matern kernel with \eqn{\nu=2.5}). Default is \code{"sqex"}.}

\item{XX}{A list containing a pseudo-complete inputs \code{X_star}(\eqn{\left\{\mathcal{X}^*_l\right\}_{l=1}^{L}}), an original inputs \code{X_list}(\eqn{\left\{\mathcal{X}_l\right\}_{l=1}^{L}}), and a pseudo inputs \code{X_tilde}(\eqn{\left\{\widetilde{\mathcal{X}}_l\right\}_{l=1}^{L}}) for non-nested design.}

\item{pseudo_yy}{A list containing a pseudo-complete outputs \code{y_star}(\eqn{\left\{\mathbf{y}^*_l\right\}_{l=1}^{L}}), an original outputs \code{y_list}(\eqn{\left\{\mathbf{y}_l\right\}_{l=1}^{L}}), and a pseudo outputs \code{y_tilde}(\eqn{\left\{\widetilde{\mathbf{y}}_l\right\}_{l=1}^{L}}) imputed by \code{\link{imputer_RNA}}.}
}
\value{
A list of predictive posterior mean and variance for each level containing:
\itemize{
  \item \code{mu}: A list of predictive posterior mean at each fidelity level.
  \item \code{sig2}: A list of predictive posterior variance at each fidelity level.
}
}
\description{
The function computes the closed-form posterior mean and variance for the RNAmf model
both at the fidelity levels used in model fitting using the chosen kernel.
}
