% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partial_points.R
\name{calc_partial_roc_points}
\alias{calc_partial_roc_points}
\title{Calculate ROC curve partial points}
\usage{
calc_partial_roc_points(
  data = NULL,
  response = NULL,
  predictor = NULL,
  lower_threshold,
  upper_threshold,
  ratio,
  .condition = NULL
)
}
\arguments{
\item{data}{A data.frame or extension (e.g. a tibble) containing values for
predictors and response variables.}

\item{response}{A data variable which must be a factor, integer or character
vector representing the prediction outcome on each observation
(\emph{Gold Standard}).

If the variable presents more than two possible outcomes, classes or
categories:
\itemize{
\item The outcome of interest (the one to be predicted) will remain distinct.
\item All other categories will be combined into a single category.
}

New combined category represents the "absence" of the condition to predict.
See \code{.condition} for more information.}

\item{predictor}{A data variable which must be numeric, representing values
of a classifier or predictor for each observation.}

\item{lower_threshold, upper_threshold}{Two numbers between 0 and 1,
inclusive.
These numbers represent lower and upper bounds of the region where to
apply calculations.}

\item{ratio}{Ratio or axis where to apply calculations.
\itemize{
\item If \code{"tpr"}, only points within the specified region of TPR, y axis, will be
considered for calculations.
\item If \code{"fpr"}, only points within the specified region of FPR, x axis, will be
considered for calculations.
}}

\item{.condition}{A value from response that represents class, category or
condition of interest which wants to be predicted.

If \code{NULL}, condition of interest will be selected automatically depending on
\code{response} type.

Once the class of interest is selected, rest of them will be collapsed in a
common category, representing the "absence" of the condition to be predicted.

See \code{vignette("selecting-condition")} for further information on how
automatic selection is performed and details on selecting the condition of
interest.}
}
\value{
A tibble with two columns:
\itemize{
\item "tpr". Containing "true positive ratio", or y, values of points
within the specified region.
\item "fpr". Containing "false positive ratio", or x, values of points
within the specified region.
}
}
\description{
Calculates a series pairs of (FPR, TPR) which correspond to ROC curve points
in a specified region.
}
\examples{
# Calc ROC points of Sepal.Width as a classifier of setosa species
# in TPR = (0.9, 1)
calc_partial_roc_points(
 iris,
 response = Species,
 predictor = Sepal.Width,
 lower_threshold = 0.9,
 upper_threshold = 1,
 ratio = "tpr"
)

# Change class to virginica
calc_partial_roc_points(
 iris,
 response = Species,
 predictor = Sepal.Width,
 lower_threshold = 0.9,
 upper_threshold = 1,
 ratio = "tpr",
 .condition = "virginica"
)
}
