% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{example_model}
\alias{example_model}
\title{Example regression model and H0.}
\usage{
example_model(n = 100)
}
\arguments{
\item{n}{Number of datapoints.}
}
\value{
List of (y, X, lam, lam0) that corresponds to regression model and null hypothesis:
\itemize{
  \item y = n-length vector of outcomes
  \item X = n x p covariate matrix;
  \item lam = p-vector of coefficients
  \item lam0 = real number.
  }

The null we are testing through this specification is

        H0: lam' beta = lam[1] * beta[1] + ... + lam[p] * beta[p] = lam0,

where beta are the model parameters in the regression, y = X beta + e.
By default this example sets p = 2-dim model, lam = (0, 1) and lam0 = 0. In this specification, H0: beta[2] = 0.
}
\description{
Example regression model and H0.
}
\examples{
model = example_model()
lm(model$y ~ model$X + 0)
}
