% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_split_sample_groups.R
\name{split_sample_groups}
\alias{split_sample_groups}
\title{Split sample groups}
\usage{
split_sample_groups(sample, new_groups, delimiter = "_")
}
\arguments{
\item{sample}{an \code{array} of samples imported with \code{load_samples()}}

\item{new_groups}{A string vector of names for each new group.}

\item{delimiter}{A character that specifies the break between group categories.}
}
\value{
An \code{array} of samples with separate margins for stratified groups.
}
\description{
Sequesters stratified sociodemographic group margin into individual array margins.
}
\details{
When using \code{aggregate_samples()} or \code{standardize_samples()}, the group/age margin must only feature groups of similar type, e.g., you cannot age-standardize with groups that specify both age and race. \code{split_sample_groups()} sequesters each category of group into its own margin to allow group-aggregation and age-standardization of these multiply-stratified groups. Ensure that the delimiter character is only used to split groups. E.g., for an age-sex group named \code{35-64_m}, \code{"_"} will split the margins with names \code{"35-64"} and \code{"m"}, whereas for a group named \code{35_64_m}, \code{split_sample_group()} will fail.
}
\examples{
dimnames(minsplit)[2] # Can't age-standardize due to age-sex stratification
new_groups = c("age", "sex")
delimiter = "_"
sample_split <- split_sample_groups(minsplit, new_groups, delimiter)
dimnames(sample_split)[2:3] # can now age-standardize
std_pop <- c(113154, 100640, 95799)
age_margin <- 2
sample_as <- standardize_samples(sample_split, std_pop, age_margin)
}
