% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rules.R
\name{rx_any_of}
\alias{rx_any_of}
\title{Match any of these characters exactly once.}
\usage{
rx_any_of(.data = NULL, value)
}
\arguments{
\item{.data}{Expression to append, typically pulled from the pipe \code{\%>\%}}

\item{value}{Expression to optionally match}
}
\description{
Constructs a \emph{character class}, sometimes called a
\emph{character set}. With this particular expression, you can tell the
regex engine to match only one out of several characters. It does this by
simply placing the characters you want to match between square brackets.
}
\examples{
rx_any_of(value = "abc")

# create an expression
x <- rx_any_of(value = "abc")

grepl(x, "c") # should be true
grepl(x, "d") # should be false

y <- rx() \%>\%
  rx_find("gr") \%>\%
  rx_any_of("ae") \%>\%
  rx_find("y")

regmatches("gray", regexec(y, "gray"))[[1]]
regmatches("grey", regexec(y, "grey"))[[1]]

}
\references{
Character class: \url{https://www.regular-expressions.info/charclass.html}
}
