% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.super_RaSE.R
\name{print.super_RaSE}
\alias{print.super_RaSE}
\title{Print a fitted super_RaSE object.}
\usage{
\method{print}{super_RaSE}(x, ...)
}
\arguments{
\item{x}{fitted \code{'super_RaSE'} model object.}

\item{...}{additional arguments.}
}
\value{
No value is returned.
}
\description{
Similar to the usual print methods, this function summarizes results.
from a fitted \code{'super_RaSE'} object.
}
\examples{
set.seed(0, kind = "L'Ecuyer-CMRG")
train.data <- RaModel("classification", 1, n = 100, p = 50)
xtrain <- train.data$x
ytrain <- train.data$y

# test RaSE classifier with LDA base classifier
fit <- Rase(xtrain, ytrain, B1 = 50, B2 = 50, iteration = 0, cutoff = TRUE,
base = 'lda', cores = 2, criterion = 'ric', ranking = TRUE)

# print the summarized results
print(fit)
}
\seealso{
\code{\link{Rase}}.
}
