% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordonner_var_qualitatives_function.R
\name{ordonner_variables_qualitatives}
\alias{ordonner_variables_qualitatives}
\title{Reorder Levels of Qualitative Variables by Frequency}
\usage{
ordonner_variables_qualitatives(data)
}
\arguments{
\item{data}{A data frame containing the dataset with qualitative variables to reorder.}
}
\value{
A data frame with reordered levels for all factor variables. Non-factor variables remain unchanged.
}
\description{
This function reorders the levels of all qualitative (factor) variables in a dataset based on their frequency,
in descending order. It ensures that the most frequent levels appear first when analyzing or visualizing the data.
}
\details{
The function applies the following transformations:
\itemize{
\item Identifies all columns of type \code{factor} in the dataset.
\item Reorders the levels of each factor variable using the \code{forcats::fct_infreq()} function,
which orders levels by decreasing frequency.
}

This is particularly useful for preparing datasets for visualization or analysis, where it can be helpful
to have the most common levels displayed first.
}
\examples{
# Example usage:
library(dplyr)
library(forcats)

# Create a sample dataset
data <- data.frame(
  var1 = factor(c("A", "B", "A", "C", "B", "B")),
  var2 = factor(c("X", "Y", "X", "Y", "X", "Z")),
  var3 = c(1, 2, 3, 4, 5, 6)  # Non-factor variable
)

# Reorder qualitative variables by frequency
data <- ordonner_variables_qualitatives(data)

# Check the new order of levels
levels(data$var1) # Output: "B" "A" "C"
levels(data$var2) # Output: "X" "Y" "Z"

}
