% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Auxiliary.R
\name{graph.from.csv}
\alias{graph.from.csv}
\title{Loads a graph from Node / Edge CSV files}
\usage{
graph.from.csv(nodeinfo_path, edgeinfo_path, ...)
}
\arguments{
\item{nodeinfo_path}{Path to a CSV file containing the node information. This CSV file should follow the convention of `node_name, initial_value`.}

\item{edgeinfo_path}{Path to a CSV file containing the edge information. This CSV file should follow the convention of `source_node_name, target_node_name, edge_weight`.}

\item{...}{Additional arguments passed to read.csv}
}
\value{
A list `L` with the following entries:
\item{\code{M:}}{ the adjacency matrix of the network.}
\item{\code{initial_values:}}{ an array of initial values for the network.}
\item{\code{node_index:}}{ a function that takes a node name and returns its index value.}
\item{\code{node_value:}}{ a function that takes a node name and returns its initial value.}
\item{\code{edge_index:}}{ a  function that takes two node names and returns the index value of the edge connecting them.}
\item{\code{edge_weight:}}{ a function that takes two node names and returns the weight of the edge connecting them.}
\item{\code{g:}}{ the igraph graph associated with the network. }
\item{\code{edges:}}{ an array of edges.}
\item{\code{nodes:}}{ an array of nodes.}
\item{\code{node_names:}}{ an array of node names.}
}
\description{
This function takes the file paths to two CSV files: one containing the node information of a network
and the other containing the edge information of the network. It returns a list containing several
useful data related to the network.
}
\examples{
\donttest{
   node_file <- system.file("extdata", "IL17.nodes.csv", package = "Rato")
   edge_file <- system.file("extdata", "IL17.edges.csv", package = "Rato")
   M <- graph.from.csv(node_file, edge_file)
}
}
