% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{col_auc_vec}
\alias{col_auc_vec}
\title{Vectorized version of function col_auc}
\usage{
col_auc_vec(x, y, args = NULL)
}
\arguments{
\item{x}{List, where each element is an input to \code{x} in \code{\link{col_auc}}.}

\item{y}{List, where each element is an input to \code{y} in \code{\link{col_auc}}.}

\item{args}{\code{NULL} (default) or list where each element is an input to \code{args}
in \code{\link{col_auc}}.}
}
\value{
List, where each element is an output from \code{\link{col_auc}}.
}
\description{
This is the vectorized version of \code{\link{col_auc}}.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the function.}
}
}
\examples{
if (require("MASS", quietly = TRUE) == TRUE) {
  data(cats)
  print(res_cpp <- col_auc_vec(list(cats[, 2L:3L]), list(cats[, 1L])))
  # Validate with caTools::colAUC()
  if (require("caTools", quietly = TRUE) == TRUE) {
    print(res_r <- caTools::colAUC(cats[, 2L:3L], cats[, 1L]))
    identical(res_cpp, list(res_r))
  }
}
}
\seealso{
\code{\link{col_auc}} for the non-vectorized version.
}
