% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{factor2char}
\alias{factor2char}
\alias{char2factor}
\title{Convert Index and String Vector into CharacterVector, and vice versa}
\usage{
factor2char(iv)

char2factor(sv)
}
\arguments{
\item{iv}{A Integer Vector corresponding to numeric representation of the factor
This vector is also expected to have an attribute \sQuote{levels} with the factor
levels}

\item{sv}{A String Vector}
}
\value{
A Character Vector which at each position contains the level value of the
corresponding index, or a Factor, depending on the function
}
\description{
These two functions are an illustration of how \code{as.character} and
\code{as.factor} may be reimplemented at the C++ level.
}
\examples{
f <- as.factor(c("red", "green", "blue", "red"))
factor2char(f);
f <- as.factor(c("red", "green", "blue", "red"))
v <- factor2char(f);
char2factor(v)
}
