% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplfit_onerun.R
\name{summarize_fit_output}
\alias{summarize_fit_output}
\title{Summarize the results from the parametric fitting using types of models}
\usage{
summarize_fit_output(
  d,
  thr_resp = 20,
  perc_resp = 10,
  ci_level = 0.95,
  extract_only = FALSE
)
}
\arguments{
\item{d}{The output from the \code{\link[=run_fit]{run_fit()}}.}

\item{thr_resp}{The response cutoff to calculate the potency. Default = 20 (POD20)}

\item{perc_resp}{The percentage cutoff to calculate the potency. Default = 10 (EC10).}

\item{ci_level}{The confidence level for the activity metrics. Default is = 0.95.}

\item{extract_only}{Whether act_summary data should be produced. Default = FALSE.}
}
\value{
A list of named components: result and result_nested (and act_summary).
The result and result_nested are the copy from the output of \code{\link[=run_fit]{run_fit()}}.
An act_set is added under the result component.
If (extract_only = FALSE), an act_summary is added.
}
\description{
The function first extracts the activity data based on the fit the supplied input parameters.
In addition, summary of activity data (e.g., confidence interval, hit confidence) can be produced.
}
\details{
A tibble, act_set is generated. When (extract_only = FALSE), a tibble, act_summary is generated with confidence intervals of the activity metrics.
The quantile approach is used to calculate the confidence interval.
Currently only bootstrap calculations from hill (3-parameter) can generate confidence interval
For potency activity metrics, if value is NA, highest tested concentration is used in the summary.
For other activity metrics, if value is NA, 0 is used in the summary.
}
\section{Hit definition}{
\subsection{cnst}{

If the cnst is the winning model and the median of responses larger than the thr_resp, it is considered as an hit.
The median of responses is reported as Emax and the lowest tested concentration is reported as EC50, POD, ECxx.
}

\subsection{hill}{

The hit (=1) is considered having POD < max tested concentration.
}

\subsection{cc2}{

The hit value is from the cc2 value
}
}

\section{Output structure}{
output
|- result (list)
|   |- fit_set (tibble, all output from the respective fit model included)
|   |- resp_set (tibble)
|   |- act_set (tibble, EC50, ECxx, Emax, POD, slope, hit)
|
|- result_nested (tibble)
|- act_summary (tibble, confidence interval)
}

\section{activity metrics}{
\describe{
\item{hit}{hit call, see above definition}
\item{EC50}{half maximal effect concentration}
\item{ECxx}{effect concentration at XX percent, depending on the perc_resp }
\item{POD}{point-of-departure, depending on the thr_resp}
\item{Emax}{max effect - min effect from the fit}
\item{slope}{slope factor from the fit}
}
}

\examples{

# generate some fit outputs

\donttest{
## fit only
fitd1 <- run_fit(zfishbeh, modls = "cc2")

## fit + bootstrap samples
fitd2 <- run_fit(zfishbeh, n_samples = 3, modls = "hill")

## fit using hill + cnst
fitd3 <- run_fit(zfishbeh, modls = c("hill", "cnst"))


# only to extract the activity data
sumd1 <- summarize_fit_output(fitd1, extract_only = TRUE)
sumd3 <- summarize_fit_output(fitd3, extract_only = TRUE)

# calculate EC20 instead of default EC10
sumd1 <- summarize_fit_output(fitd1, extract_only = TRUE, perc_resp  = 20)

# calculate POD using a higher noise level (e.g., 40)
## this number depends on the response unit
sumd1 <- summarize_fit_output(fitd1, extract_only = TRUE, thr_resp  = 40)

# calculate confidence intervals based on the bootstrap samples
sumd2 <- summarize_fit_output(fitd2)

}

}
\seealso{
\code{\link[=run_fit]{run_fit()}}
}
