% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CONCEPT.R
\docType{data}
\name{SNOMED_CONCEPT}
\alias{SNOMED_CONCEPT}
\alias{CONCEPT}
\title{Sample concept table from SNOMED CT dictionary}
\format{
An object of class \code{"data.table"}
}
\usage{
data(CONCEPT)
}
\description{
A sample of the SNOMED CT concept table.
}
\details{
\describe{
  \item{id}{ integer64: SNOMED CT conceptId (primary key)} 
  \item{moduleId}{ integer64: class of SNOMED CT concept (whether it is used for recording information or is a metadata concept)}
  \item{definitionStatusId}{ integer64: 900000000000074008 = primitive concept, 900000000000073002 = defined by conditions}
  \item{effectiveTime}{ IDate: when the concept became active}
  \item{active}{ logical: whether this concept is currently active}
}
}
\examples{
# Show properties of the CONCEPT table
data('CONCEPT')
str(CONCEPT)
}
\seealso{
Other sampleSNOMED: 
\code{\link{HISTORY}},
\code{\link{READMAPS}},
\code{\link{SNOMED_DESCRIPTION}},
\code{\link{SNOMED_EXTENDEDMAP}},
\code{\link{SNOMED_REFSET}},
\code{\link{SNOMED_RELATIONSHIP}},
\code{\link{SNOMED_SIMPLEMAP}},
\code{\link{sampleSNOMED}()}
}
\concept{sampleSNOMED}
\keyword{datasets}
