% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SNOMEDcodelist.R, R/concepts.R
\name{as.data.frame.SNOMEDconcept}
\alias{as.data.frame.SNOMEDconcept}
\alias{as.integer64.SNOMEDconcept}
\alias{SNOMEDconcept}
\alias{as.SNOMEDconcept}
\title{Return the SNOMED CT concept IDs for a set of terms}
\usage{
\method{as.data.frame}{SNOMEDconcept}(x, ...)

\method{as.integer64}{SNOMEDconcept}(x, ...)

SNOMEDconcept(
  x,
  active_only = TRUE,
  exact_match = TRUE,
  unique = TRUE,
  SNOMED = getSNOMED()
)

as.SNOMEDconcept(x, ...)
}
\arguments{
\item{x}{character vector of terms to match, or
character vector containing SNOMED CT concept IDs, or
64-bit integer vector containing SNOMED CT concept IDs}

\item{...}{additional arguments to send to grepl if using
regular expression matching}

\item{active_only}{whether or not to include inactive concepts}

\item{exact_match}{if TRUE, only an exact (case sensitive)
match is performed. If FALSE, a regular expression match
is performed.}

\item{unique}{whether to include no more than one instance of each
SNOMED CT concept}

\item{SNOMED}{environment containing SNOMED dictionary. Defaults
to an object named 'SNOMED' in the global environment}
}
\value{
a SNOMEDconcept object (vector of 64-bit integers) containing
  unique SNOMED CT concept IDs
}
\description{
Carries out an exact or regular expression match to
return the concept ID for a set of search terms, or
converts a character, integer or integer64 vector to a
SNOMEDconcept object.
}
\examples{
SNOMEDconcept('Heart failure', SNOMED = sampleSNOMED()) -> hf
is.SNOMEDconcept(hf)
SNOMEDconcept('900000000000003001')
as.SNOMEDconcept('900000000000003001')
}
\seealso{
Other SNOMEDconcept functions: 
\code{\link{c.SNOMEDconcept}()},
\code{\link{is.SNOMEDconcept}()},
\code{\link{print.SNOMEDconcept}()},
\code{\link{union.SNOMEDconcept}()},
\code{\link{unique.SNOMEDconcept}()}

Other SNOMEDconcept functions: 
\code{\link{c.SNOMEDconcept}()},
\code{\link{is.SNOMEDconcept}()},
\code{\link{print.SNOMEDconcept}()},
\code{\link{union.SNOMEDconcept}()},
\code{\link{unique.SNOMEDconcept}()}

Other SNOMEDconcept functions: 
\code{\link{c.SNOMEDconcept}()},
\code{\link{is.SNOMEDconcept}()},
\code{\link{print.SNOMEDconcept}()},
\code{\link{union.SNOMEDconcept}()},
\code{\link{unique.SNOMEDconcept}()}
}
\concept{SNOMEDconcept functions}
