% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordnet.R
\name{downloadWordnet}
\alias{downloadWordnet}
\title{Download WordNet to assist concept database creation}
\usage{
downloadWordnet(
  wordnet_url = "https://wordnetcode.princeton.edu/wn3.1.dict.tar.gz",
  wn_categories = c("noun.body", "noun.state", "noun.process", "noun.animal",
    "noun.plant", "noun.phenomenon")
)
}
\arguments{
\item{wordnet_url}{URL or filepath to WordNet tar.gz file}

\item{wn_categories}{WordNet categories from which to extract data}
}
\value{
data.table containing WordNet data from appropriate
  categories, in the format: cat (character), wordnetId (integer64),
  synonyms (list), parents (list), adj (list)
}
\description{
Downloads the WordNet thesaurus and converts it into a format to be
used by addWordnet to add extra synonyms to a concept database.
}
\examples{
# Not run
# WORDNET <- downloadWordnet()
}
\references{
\url{https://wordnet.princeton.edu/}
}
\seealso{
addWordnet

Other CDB functions: 
\code{\link{addComposeLookupToCDB}()},
\code{\link{addWordnet}()},
\code{\link{batchDecompose}()},
\code{\link{createCDB}()},
\code{\link{downloadOrphanet}()}
}
\concept{CDB functions}
